// SuwakDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Suwak.h"
#include "SuwakDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSuwakDlg dialog




CSuwakDlg::CSuwakDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSuwakDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSuwakDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PROGRESS1, Progress1);
	DDX_Control(pDX, IDC_SLIDER1, Slider1);
	DDX_Control(pDX, IDC_EDIT1, Edit1);
}

BEGIN_MESSAGE_MAP(CSuwakDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_NOTIFY(TRBN_THUMBPOSCHANGING, IDC_SLIDER1, &CSuwakDlg::OnTRBNThumbPosChangingSlider1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER1, &CSuwakDlg::OnNMCustomdrawSlider1)
END_MESSAGE_MAP()


// CSuwakDlg message handlers

BOOL CSuwakDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	Progress1.SetRange(0,255);
	Progress1.SetPos(0);
	Slider1.SetRangeMin(0);
	Slider1.SetRangeMax(255);
	Slider1.SetTicFreq(15);
	Slider1.SetPos(0);
	Edit1.SetWindowText(L"0%");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSuwakDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSuwakDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CSuwakDlg::OnTRBNThumbPosChangingSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	// This feature requires Windows Vista or greater.
	// The symbol _WIN32_WINNT must be >= 0x0600.
	NMTRBTHUMBPOSCHANGING *pNMTPC = reinterpret_cast<NMTRBTHUMBPOSCHANGING *>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	Progress1.SetPos(Slider1.GetPos());

	wchar_t bufor[10]=L"";
	int minimum,maximum;
	Progress1.GetRange(minimum,maximum);
	int procent=100*(Progress1.GetPos()-minimum)/(maximum-minimum);
	_itow_s(procent,bufor,10,10);
	wcscat_s(bufor,10,L"%");
	Edit1.SetWindowText(bufor);
}

void CSuwakDlg::OnNMCustomdrawSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	OSVERSIONINFO wersja;
    ZeroMemory(&wersja, sizeof(OSVERSIONINFO));
    wersja.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    GetVersionEx(&wersja);
	//wchar_t glownyNumerWersji[256];
	//_itow(wersja.dwMajorVersion,glownyNumerWersji,10);
	//this->SetWindowTextW(glownyNumerWersji);
	if (wersja.dwMajorVersion<6)
	{
		OnTRBNThumbPosChangingSlider1(pNMHDR,pResult);
	}
}
